/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class PropertySet {
    private String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private Vector attributeVector = null;
    private String DN = null;
    private Attributes attributeSet = null;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;

    protected PropertySet() {
        this.attributeVector = new Vector();
    }

    protected PropertySet(String string, Attributes attributes, Vector vector) {
        this.DN = new String(string);
        this.attributeSet = attributes;
        this.attributeVector = vector;
    }

    protected PropertySet(String string, SearchResult searchResult) {
        this.attributeVector = new Vector();
        this.DN = searchResult.getName().length() > 0 ? (string.equals("") ? new String(searchResult.getName()) : new String(searchResult.getName() + "," + string)) : new String(string);
        this.attributeSet = searchResult.getAttributes();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = this.attributeSet.getAll();
            while (namingEnumeration.hasMore()) {
                this.attributeVector.addElement(namingEnumeration.next());
            }
        }
        catch (NamingException namingException) {}
    }

    public final boolean isEmpty() {
        return this.attributeVector.isEmpty();
    }

    public final int size() {
        return this.attributeVector.size();
    }

    public final String[] getAttributeNames() {
        int n = this.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((Attribute)this.attributeVector.elementAt(n2)).getID();
            ++n2;
        }
        return stringArray;
    }

    public final Property getProperty(int n) {
        return new Property((Attribute)this.attributeVector.elementAt(n));
    }

    public final Property getProperty(String string) {
        Property property = null;
        Attribute attribute = this.attributeSet.get(string);
        if (attribute != null) {
            property = new Property(attribute);
        }
        return property;
    }

    public final String getDN() {
        return this.DN;
    }

    protected void mergePropertySet(PropertySet propertySet) {
        Attributes attributes = propertySet.getAttributeSet();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                Attribute attribute = namingEnumeration.next();
                this.attributeVector.addElement(attribute);
                this.attributeSet.put(attribute);
            }
        }
        catch (NamingException namingException) {}
    }

    protected String[] getMissingAttributes(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            Attribute attribute = null;
            if (stringArray[n] != null) {
                attribute = this.attributeSet.get(stringArray[n]);
            }
            if (attribute == null) {
                vector.add(stringArray[n]);
            }
            ++n;
        }
        int n2 = vector.size();
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray2[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray2;
    }

    protected PropertySet returnPropertySet(String[] stringArray) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        Vector<Attribute> vector = new Vector<Attribute>();
        int n = 0;
        while (n < stringArray.length) {
            Attribute attribute = null;
            if (stringArray[n] != null) {
                attribute = this.attributeSet.get(stringArray[n]);
            }
            if (attribute != null) {
                vector.addElement(attribute);
                basicAttributes.put(attribute);
            }
            ++n;
        }
        return new PropertySet(this.getDN(), basicAttributes, vector);
    }

    protected Attributes getAttributeSet() {
        return this.attributeSet;
    }

    protected PropertySet doSearch(DirContext dirContext, String[] stringArray) throws UtilException {
        try {
            String[] stringArray2 = this.getMissingAttributes(stringArray);
            PropertySetCollection propertySetCollection = null;
            if (stringArray2.length > 0) {
                propertySetCollection = Util.getEntryDetails(dirContext, this.DN, "(objectclass=*)", 0, stringArray2);
                this.mergePropertySet(propertySetCollection.getPropertySet(0));
            }
            return this.returnPropertySet(stringArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH") + this.DN, namingException);
        }
    }
}

